/*
 * CODE TO AGC 
 * 2009/11/20 
 * OS : WINXP SP3
 * TOTAL CODE FOR MODEL
 */
#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include <time.h>
#include <conio.h>
#include "CAN_DEV_FUNC.h"
#include ".\AR-B6002.h"

BOOL IsWriting = FALSE;

struct _FuncTable {
  void (*func)();
  const char str[255];
};

u32  MemBaseAddr=0;
u32  IoBaseAddr=0;
i32  Cmd=0;
i16  Selected=0;
u32  Offset=0;
u8   Value8=0;
u16  Value16=0;
i32  Value=0;
u32  Value32=0;
i16  SRAMMode=0;
u32  MemSize=0x100000;
u32  Errbox = 0;  

static struct _FuncTable FuncTable[]=
{
  {CSM,"Send Canbus messages"},
  {CGM,"Get Canbus messages"},
  {CSC,"Set Canbus configuration"},
  {CST, "Canbus stress test. Send packages."}
};

int main(int argc, char* argv[])
{
  i32  i;
  printf("    Acrosser Gaming I/O Board Test Program \n");
  
  //setCallbackFunc(&IOIST);
  //DWORD ThreadId;

  while(TRUE)
  {
    printf("\n");
    printf("    ========== MENU =========\n");
    printf("   (0) Exit\n");

	for(i = 0 ; i < ( sizeof(FuncTable) / sizeof(FuncTable[0]) ) ; i++)
    {
      printf("   (%d) ",i+1);
      printf(FuncTable[i].str);
      printf("\n");
    }
	printf("   =========================\n");

CMD_RETRY:
    printf("  >> ");
    scanf_s("%d",&Cmd);

    if ((Cmd < 0) || (Cmd > ( sizeof(FuncTable) / sizeof(FuncTable[0]) )))
      goto CMD_RETRY;
    
	if (Cmd == 0) goto APP_END;
    
	(*(FuncTable[Cmd-1].func))();
  }

APP_END:

  //releaseCard();
  return 0;
} //end main




void CSM()
{
	canmsg_t tx[255];
	IsWriting = TRUE;
	int i;
	canmsg_t *pTx=tx;

	for(int i=0; i<250; i++) 
	{
		sprintf( (char*)(&(tx[i].data[0])),"msg%d",i);
		//printf("sending '%s'\n", tx[i].data );
		tx[i].flags = 0;  
		tx[i].length = strlen((char*)(tx[i].data));  
		tx[i].id=500+i;
	}
    
//	for(i=0; i<200; i++) {
		sendCanMessages(pTx, 200);
//		pTx++;
//	}
	IsWriting = FALSE;

}

void CGM()
{
	canmsg_t rx[255];
	int count=0;

	while(1) 
	{
		if(IsWriting) continue;
		getCanMessages(&(rx[0]), 1);
		printf("Get %d messages !\n", ++count);
	    printf("Received with ret=%d: %12lu.%06lu id=%ld/0x%08lx\n",
		    0,  rx[0].timestamp.tv_sec,  rx[0].timestamp.tv_usec,  rx[0].id, rx[0].id);
	    printf("\tlen=%d", rx[0].length);
	    printf(" flags=0x%02x", rx[0].flags );
	    printf(" : %c%c : msg=",
	    		(rx[0].flags & MSG_EXT) ? 'e' : 's',
	    		(rx[0].flags & MSG_RTR) ? 'R' : 'D');
	    if( !(rx[0].flags & MSG_RTR) ) 
		{
			for(int j = 0; j < rx[0].length; j++) 
			{
				printf(" %02x", rx[0].data[j]);
			}
	    }
	    printf("\n");
	}
}

void CSC()
{
	int baud;

	printf("Please input canbus baud rate: ");
	scanf_s("%d", &baud);
	Errbox = configCan(baud);
	
	if(Errbox != 0)
		printf("Error => %08x.\n",Errbox);
	else
		printf("Setting canbus baud rate to %d.\n", baud);
}

void CST()
{
	canmsg_t tx[255];
	IsWriting = TRUE;
	unsigned char count=1;
	canmsg_t *pTx=tx;

	for(int i=0; i<250; i++) 
	{
      sprintf( (char*)(&(tx[i].data[0])),"msg%d",i);
	  tx[i].flags = 0;  
	  tx[i].length = strlen((char*)(tx[i].data));  
	  tx[i].id=500+i;
	}

	while(1) {

      sendCanMessages(pTx, 200);

	  printf("[%03d] sending CAN packages...\n", count++);
	}
	
}