#!/bin/bash
# VERSION 	5.3
# DATE		2022/07/14
# functions for setup diriver of Yuan's capture card.
set -e

source bash_functions.sh

# Variants
VERSION="R5.3 2022/07/14"

D_DATE=$(date '+%Y%m%d_%H%M%S');
D_VER=`uname -r`
PATH_CURR=`pwd`
PATH_DRIVER_V4L="driver/V4L"
PATH_DRIVER_SAMBA="driver/samba"
PATH_DRIVER_V4L2_NVARGUS_="driver/tegra"
PATH_MODULE="/lib/modules/${D_VER}"
PATH_MODULE_MISC="/lib/modules/${D_VER}/misc"
PATH_NLS="${PATH_MODULE}/kernel/fs/nls"
PATH_V4L2_CORE="${PATH_MODULE}/kernel/drivers/media/v4l2-core"
PATH_V4L2_NVARGUS="/usr/lib/aarch64-linux-gnu/tegra"
FN_V4L_CORE="videobuf-core"
FN_V4L_DMA="videobuf-dma-sg"
FN_V4L_CONT="videobuf-dma-contig"
FN_V4L_VMAL="videobuf-vmalloc"
FN_V4L2_DMA="videobuf2-dma-sg"
FN_V4L2_VMAL="videobuf2-vmalloc"
FN_NLS_UTF8="nls_utf8"
FN_V4L2_NVARGUS="libv4l2_nvargus.so"

PATH_FW="/lib/firmware"
FN_MODULE_A_V1="LXV4L2D_PL330A"
FN_MODULE_B_V1="LXV4L2D_PL330B"
FN_MODULE_A_V2="LXV4L2D_QP0204"
FN_MODULE_B_V2="LXV4L2D_QP0203"
FN_MODULE_M="LXV4L2D_MZ0380"
FN_MODULE_700="LXV4L2D_SC0700"
FN_MODULE_710="LXV4L2D_SC0710"
FN_MODULE_720="LXV4L2D_SC0720"

D_FALSE=0
D_TRUE=1
IS_V1="${D_FALSE}"
IS_DEBUG="${D_TRUE}"

FN_KO=""
DEP_VER_KERNEL=""
S_RET="0"

FN="${PATH_CURR}/log_setup.txt"


# cp firmware to /lib/firmware
echo_title()
{
	echo "=====================================" >> ${FN}
	echo $@ >> ${FN} 
	echo "=====================================" >> ${FN}
}

run_cmdl()
{
	echo "$@"
	echo $@ >> ${FN}
	
	#print to console
	$@
}

print_version()
{
	echo_title ${VERSION}
}

cp_firmware()
{
	echo_title "copy firmware"
	mkDirectory ${PATH_FW}
	run_cmdl sudo cp -Rf firmware/* ${PATH_FW}
}

copy_module()
{
	mkDirectory ${PATH_MODULE}
	mkDirectory ${PATH_MODULE_MISC}
	mkDirectory ${PATH_V4L2_CORE}
	#run_cmd cp -rf ${PATH_DRIVER_V4L}/${FN_V4L_CORE}.ko ${PATH_V4L2_CORE}
	run_cmdl cp -rf ${PATH_DRIVER_V4L}/${FN_V4L_DMA}.ko ${PATH_V4L2_CORE}
	run_cmdl cp -rf ${PATH_DRIVER_V4L}/${FN_V4L_CONT}.ko ${PATH_V4L2_CORE}
	#run_cmd cp -rf ${PATH_DRIVER_V4L}/${FN_V4L_VMAL}.ko ${PATH_V4L2_CORE}
	run_cmdl cp -rf ${PATH_DRIVER_V4L}/${FN_V4L2_DMA}.ko ${PATH_V4L2_CORE}
	#run_cmd cp -rf ${PATH_DRIVER_V4L}/${FN_V4L2_VMAL}.ko ${PATH_V4L2_CORE}
	#run_cmd cp -rf driver/${FN_MODULE}.ko /lib/modules/${D_VER}/

	if [ ${IS_DEBUG} == "${D_TRUE}" ];then
		echo_title "copy debug driver "
		run_cmdl cp -rf driver/debug/*.ko ${PATH_MODULE_MISC}/
	else
		echo_title "copy driver"
		run_cmdl cp -rf driver/*.ko ${PATH_MODULE_MISC}/
	fi
}

copy_module_samba()
{
	echo_title "copy samba driver"
	mkDirectory ${PATH_MODULE}
	mkDirectory ${PATH_MODULE_MISC}
	mkDirectory ${PATH_NLS}
	run_cmdl cp -f ${PATH_DRIVER_SAMBA}/${FN_NLS_UTF8}.ko ${PATH_NLS}
}

insert_module()
{
	if [ -f ${1}.ko ];then
		run_cmdl sudo modprobe ${1}
	fi
}

driver_install()
{
	echo_title "driver reinstall"
	cd ${PATH_MODULE}
	run_cmdl sudo depmod -a
	cd ${PATH_V4L2_CORE}
	#insert_module ${FN_V4L_CORE}
	insert_module ${FN_V4L_DMA}
	insert_module ${FN_V4L_CONT}
	#insert_module ${FN_V4L_VMAL}
	insert_module ${FN_V4L2_DMA}
	#insert_module ${FN_V4L2_VMAL}
	
	#cd ${PATH_MODULE}
	cd ${PATH_MODULE_MISC}
	if [ ${IS_V1} = "${D_TRUE}" ];then
		insert_module ${FN_MODULE_A_V1}
		insert_module ${FN_MODULE_B_V1}
	else
		insert_module ${FN_MODULE_A_V2}
		insert_module ${FN_MODULE_B_V2}
	fi
	insert_module ${FN_MODULE_M}
	insert_module ${FN_MODULE_700}
	insert_module ${FN_MODULE_710}
	insert_module ${FN_MODULE_720}
	cd ${PATH_CURR}
}

driver_install_samba()
{
	echo_title "driver reinstall samba"
	cd ${PATH_MODULE}
	run_cmdl sudo depmod -a
	cd ${PATH_NLS}
	insert_module ${FN_NLS_UTF8}
	cd $PATH_CURR
}

setup_samba()
{
	copy_module_samba
	driver_install_samba
}

remove_yuan_ko()
{
	echo_title "remove_yuan_ko"
	mkDirectory ${PATH_MODULE}
	mkDirectory ${PATH_V4L2_CORE}
	run_cmdl rm -rf ${PATH_MODULE}/LXV4L2D_*.ko
	run_cmdl rm -rf ${PATH_MODULE_MISC}/LXV4L2D_*.ko
}

# https://pypi.org/project/jetson-stats/
# https://medium.com/jacky-life/jetson-nano-9d89cbf2fc18
install_jtop()
{
	sudo apt-get install -y python-pip python-dev build-essential 
	sudo pip install --upgrade pip
	sudo pip install jetson-stats
	#sudo jtop
}

#The so is incorrect, and is needed to patch for R32.5, and R32.5.1
patch_libv4l2_nvargus()
{
	echo_title "patch_libv4l2_nvargus"
	run_cmdl sudo cp -f ${PATH_DRIVER_V4L2_NVARGUS_}/${FN_V4L2_NVARGUS} ${PATH_V4L2_NVARGUS}
}

# https://linuxhint.com/trim_string_bash/
validate()
{
	echo_title "validate"
	#The ko version must same as kernel release
	#01.Get the ko file list
	STR_RET=$(ls -l driver/*.ko)
	#echo "STR_RET=${STR_RET}"
	
	#02.Compare the version between ko file ane kernel release
	text=${STR_RET}
	readarray -t strarr <<< "$text"
	
	for (( i=0; i<=${#strarr[*]}; i++ ))
	do
		#echo "${i}=${strarr[${i}]}"
		FN_KO=$(echo ${strarr[${i}]} | cut -d '/' -f 2) 
		#echo "FN_KO=${FN_KO}"
			
		DEP_VER_KERNEL=`modinfo driver/${FN_KO} | grep vermagic | cut -d ':' -f2 | cut -d 'S' -f1`
		DEP_VER_KERNEL=`echo $DEP_VER_KERNEL | sed 's/ *$//g'`
		#echo "DEP_VER_KERNEL=${DEP_VER_KERNEL}"
		
		if [ ! -z ${DEP_VER_KERNEL} ];then
			if [ "${DEP_VER_KERNEL}" == "${D_VER}" ];then
				run_cmdl echo "module ${FN_KO}.version(${DEP_VER_KERNEL}) == Kernel.version(${D_VER})"
				return
			else
				run_cmdl echo "Driver is for ${DEP_VER_KERNEL}, but kernel release is ${D_VER}"
				run_cmdl echo "This driver can't be used on this, please contact with vendor to get correct driver version."
				exit
			fi
		fi
	done
	exit
}

get_modinfo()
{
	echo_title "get_modinfo"
	#The ko version must same as kernel release
	#01.Get the ko file list
	cd ${PATH_MODULE_MISC}
	STR_RET=$(ls -l *.ko)
	#echo "STR_RET=${STR_RET}"
	
	#02.Compare the version between ko file ane kernel release
	text=${STR_RET}
	readarray -t strarr <<< "$text"
	
	for (( i=0; i<=${#strarr[*]}; i++ ))
	do
		#echo "${i}=${strarr[${i}]}"
		FN_KO=$(echo ${strarr[${i}]} | cut -d ' ' -f 9) 
		if [ -n "${FN_KO}" ];then
			#echo "FN_KO=${FN_KO}"
			run_cmd modinfo ${PATH_MODULE_MISC}/${FN_KO} 
		fi
		
	done
	cd ${PATH_CURR}
}

get_driver()
{
	run_cmdl ls -l /lib/firmware/ 
	run_cmdl ls -l ${PATH_MODULE}
	run_cmdl ls -l ${PATH_MODULE_MISC}
	get_modinfo
	run_cmdl lsmod
}

main()
{
	echo "" > ${FN}
	print_version
	validate
	remove_yuan_ko
	cp_firmware
	copy_module
	driver_install
	#patch_libv4l2_nvargus
	#get_driver
	#setup_samba
	#install_jtop
}

main;
echo "Please reboot to use new firmware of capture card, if there is no error message,thanks."

