// RecordPanel.cpp : implementation file
//

#include "stdafx.h"
#include "MultiRecoderDemo.h"
#include "RecordPanel.h"

#include "MultiRecoderDemoDlg.h"

#include "LivePropertyDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRecordPanel dialog

CRecordPanel::CRecordPanel(CWnd* pParent /*=NULL*/)
	: CDialog(CRecordPanel::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRecordPanel)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CRecordPanel::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRecordPanel)
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH, m_editRecordPath);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRecordPanel, CDialog)
	//{{AFX_MSG_MAP(CRecordPanel)
	ON_BN_CLICKED(IDC_BUTTON, OnButton)
	ON_BN_CLICKED(IDC_RADIO_AVI, OnRadioAvi)
	ON_BN_CLICKED(IDC_RADIO_MP4, OnRadioMp4)
	ON_CBN_SELCHANGE(IDC_COMBO_STANDARD, OnSelchangeComboStandard)
	ON_CBN_SELCHANGE(IDC_COMBO_RECORDMODE, OnSelchangeComboRecordmode)
	ON_CBN_SELCHANGE(IDC_COMBO_FRAMERATE, OnSelchangeComboFramerate)
	ON_BN_CLICKED(IDC_BUTTON_OK, OnButtonOk)
	ON_BN_CLICKED(IDC_BUTTON_NO, OnButtonNo)
	ON_CBN_SELCHANGE(IDC_COMBO_AUDIO_FORMAT, OnSelchangeComboAudioFormat)
	//ON_CBN_SELCHANGE(IDC_COMBO_VIDEO_RESOLUTION, OnSelchangeComboVideoResolution)
	ON_CBN_SELCHANGE(IDC_COMBO_BITRATE, OnSelchangeComboBitrate)
	ON_CBN_SELCHANGE(IDC_COMBO_QUALITY, OnSelchangeComboQuality)
	ON_CBN_SELCHANGE(IDC_COMBO_GOP, OnSelchangeComboGop)
	ON_CBN_SELCHANGE(IDC_COMBO_SCALE, OnSelchangeComboScale)
	ON_BN_CLICKED(IDC_CHECK_GPU, OnCheckGpu)
	ON_BN_CLICKED(IDC_CHECK_DEINTERLACE, OnCheckDeinterlace)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRecordPanel message handlers

BOOL CRecordPanel::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	// SETTING RECORD PATH
	//
	CString strFullPathName;

	//strFullPathName = m_pMainDialog->m_strRecordPath + _T("\\unname1_2_480_6M.mp4");
	strFullPathName =  pMainDlg->m_strRecordPath[ nChannelNum ];

	m_editRecordPath.SetWindowText( strFullPathName ); 


	// SETTING RECORD FORMAT
	//
	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] != 0 ) {		

		if ( pMainDlg->m_nRecordFormat[ nChannelNum ] == 0 ) { CheckDlgButton( IDC_RADIO_AVI, BST_CHECKED ); }

		if ( pMainDlg->m_nRecordFormat[ nChannelNum ] == 1 ) { CheckDlgButton( IDC_RADIO_MP4, BST_CHECKED ); }
	}

	// SETTING RECORD STANDARD
	//
	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] != 0 ) {		

		if ( pMainDlg->m_nRecordStandard[ nChannelNum ] == 0 ) { ((CComboBox*)GetDlgItem( IDC_COMBO_STANDARD ))->SetCurSel( 0 ); }

		if ( pMainDlg->m_nRecordStandard[ nChannelNum ] == 1 ) { ((CComboBox*)GetDlgItem( IDC_COMBO_STANDARD ))->SetCurSel( 1 ); }
	}

	// SETTING RECORD FRAMERATE
	//
	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] != 0 ) {	
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->SetCurSel( pMainDlg->m_nRecordFrameRatePos[ nChannelNum ] );
	}

	// SETTING RECORD FRAMERATE
	//
	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] != 0 ) {	
		
		//((CComboBox*)GetDlgItem( IDC_COMBO_VIDEO_RESOLUTION ))->SetCurSel( pMainDlg->m_nRecordResolutionPos[ nChannelNum ] );
	}
	
	OnSelchangeComboStandard();

	// SETTING RECORD VIDEO FRAMERATE
	//
	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] != 0 ) {	
		
		((CComboBox*)GetDlgItem( IDC_COMBO_VIDEO_FORMAT ))->SetCurSel( 0 );
	}

	// SETTING RECORD AUDIO FRAMERATE
	//
	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] != 0 ) {	
		
		((CComboBox*)GetDlgItem( IDC_COMBO_AUDIO_FORMAT ))->SetCurSel( pMainDlg->m_nRecordAudioFormat[ nChannelNum ] );
	}

	// SETTING GOP
	//

	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] != 0 ) {	

		for ( ULONG i = 1; i <= 255; i++ ) {

			CHAR psz[ 16 ]; 
			
			sprintf( psz, "%3d", i );

			((CComboBox*)GetDlgItem( IDC_COMBO_GOP ))->AddString( psz );

			((CComboBox*)GetDlgItem( IDC_COMBO_GOP ))->SetCurSel( pMainDlg->m_nRecordGOP[ nChannelNum ] );
		}
	}

	// SETTING RECORD BITRATES
	//
	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] != 0 ) {	
		
		((CComboBox*)GetDlgItem( IDC_COMBO_BITRATE ))->SetCurSel( pMainDlg->m_nRecordBiteRate[ nChannelNum ] );
	}

	// SETTING RECORD QUALITY
	//
	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] != 0 ) {	
		
		((CComboBox*)GetDlgItem( IDC_COMBO_QUALITY ))->SetCurSel( pMainDlg->m_nRecordQuality[ nChannelNum ] );
	}

	// SETTING RECORD MODE
	//
	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] != 0 ) {	
		
		((CComboBox*)GetDlgItem( IDC_COMBO_RECORDMODE ))->SetCurSel( pMainDlg->m_nRecordMode[ nChannelNum ] );
	}

	OnSelchangeComboRecordmode();

	// SETTING RECORD SCALE
	//
	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] != 0 ) {	
		
		((CComboBox*)GetDlgItem( IDC_COMBO_SCALE ))->SetCurSel( pMainDlg->m_nRecordScale[ nChannelNum ] );
	}

	// SETTING GPU & DEINTERLACE
	//
	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] != 0 ) {	
		
		((CButton*)GetDlgItem( IDC_CHECK_GPU ))->SetCheck( pMainDlg->m_bRecordSupportGPU[ nChannelNum ] );

		((CButton*)GetDlgItem( IDC_COMBO_SCALE ))->SetCheck( pMainDlg->m_bRecordAutoDeinterlace[ nChannelNum ] );
	}


	((CButton*)GetDlgItem( IDC_STATIC_AUDIO_FORMAT ))->ShowWindow( FALSE );	
	((CButton*)GetDlgItem( IDC_COMBO_AUDIO_FORMAT ))->ShowWindow( FALSE );

	return TRUE;  // return TRUE unlesss you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CRecordPanel::OnButton() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

    char szPath[ 1024 ];     

    CString str;

    ZeroMemory( szPath, sizeof(szPath) );   

    BROWSEINFO bi;
    bi.hwndOwner		= m_hWnd;
    bi.pidlRoot			= NULL;   
    bi.pszDisplayName	= szPath;   
    bi.lpszTitle		= "Select Record Path:";   
    bi.ulFlags			= 0;   
    bi.lpfn				= NULL;   
    bi.lParam			= 0;   
    bi.iImage			= 0;   
    
    LPITEMIDLIST lp		= SHBrowseForFolder(&bi);   

    if( lp && SHGetPathFromIDList( lp, szPath ) ) {

        str.Format( "%s",  szPath );

		pMainDlg->m_strRecordPath[ nChannelNum ] = str;

		m_editRecordPath.SetWindowText( (LPCTSTR)pMainDlg->m_strRecordPath[ nChannelNum ] ); 

		// 13.01.10
		pMainDlg->SetProfileData( pMainDlg->m_strIniDes );

    }
    else {

		AfxMessageBox("The Direction Not Exist");   	
	}
}

void CRecordPanel::OnRadioAvi() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	pMainDlg->m_nRecordFormat[ nChannelNum ] = 0x00000000;
	
	// 13.01.10
	pMainDlg->SetProfileData( pMainDlg->m_strIniDes );
}

void CRecordPanel::OnRadioMp4() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	pMainDlg->m_nRecordFormat[ nChannelNum ] = 0x00000001;

	// 13.01.10
	pMainDlg->SetProfileData( pMainDlg->m_strIniDes );
}

void CRecordPanel::OnSelchangeComboStandard() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	pMainDlg->m_nRecordStandard[ nChannelNum ] = ((CComboBox*)GetDlgItem( IDC_COMBO_STANDARD ))->GetCurSel();

	ULONG i = pMainDlg->m_nRecordStandard[ nChannelNum ];

	if ( i == 0 ) {
		
		ULONG r = pMainDlg->m_nRecordResolutionPos[ nChannelNum ];
		
		ULONG j = pMainDlg->m_nRecordFrameRatePos[ nChannelNum ];
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->ResetContent();
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( "60.000" );	// 00
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( "30.000" );	// 01
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( "15.000" ); // 02
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( " 7.500" ); // 03
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( " 3.750" ); // 04
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->SetCurSel( j );	
	}

	if ( i == 1 ) {
		
		ULONG r = pMainDlg->m_nRecordResolutionPos[ nChannelNum ];
		
		ULONG j = pMainDlg->m_nRecordFrameRatePos[ nChannelNum ];
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->ResetContent();

		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( "50.000" );	// 00
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( "25.000" ); // 01
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( "12.500" ); // 02
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( " 6.250" ); // 03
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( " 3.125" ); // 04
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->SetCurSel( j );
	}

	// 13.01.10
	pMainDlg->SetProfileData( pMainDlg->m_strIniDes );

}

void CRecordPanel::OnSelchangeComboRecordmode() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	pMainDlg->m_nRecordMode[ nChannelNum ] = ((CComboBox*)GetDlgItem( IDC_COMBO_RECORDMODE ))->GetCurSel();

	ULONG i = pMainDlg->m_nRecordMode[ nChannelNum ];

	if ( i == 0 ) { ((CComboBox*)GetDlgItem( IDC_COMBO_BITRATE ))->EnableWindow( FALSE ); }

	if ( i == 0 ) { ((CComboBox*)GetDlgItem( IDC_COMBO_QUALITY ))->EnableWindow( TRUE  ); }

	if ( i == 1 ) { ((CComboBox*)GetDlgItem( IDC_COMBO_BITRATE ))->EnableWindow( TRUE  ); }

	if ( i == 1 ) { ((CComboBox*)GetDlgItem( IDC_COMBO_QUALITY ))->EnableWindow( FALSE ); }
}

void CRecordPanel::OnSelchangeComboFramerate() 
{
	// TODO: Add your control notification handler code here
	
	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	pMainDlg->m_nRecordFrameRatePos[ nChannelNum ] = ((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->GetCurSel();

	ULONG i = pMainDlg->m_nRecordFrameRatePos[ nChannelNum ];
}

void CRecordPanel::OnButtonOk() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;
	
	m_pMainParent->SendMessage( WM_CLOSE );
	
	//m_pMainParent->DestroyWindow();

	CDialog::OnOK();
}

void CRecordPanel::OnButtonNo() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;
	
	m_pMainParent->SendMessage( WM_CLOSE );
	
	//m_pMainParent->DestroyWindow();

	CDialog::OnOK();	
}

void CRecordPanel::OnSelchangeComboAudioFormat() 
{
	// TODO: Add your control notification handler code here
	
	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	pMainDlg->m_nRecordAudioFormat[ nChannelNum ] = ((CComboBox*)GetDlgItem( IDC_COMBO_AUDIO_FORMAT ))->GetCurSel();

	ULONG i = pMainDlg->m_nRecordAudioFormat[ nChannelNum ];
}

void CRecordPanel::OnSelchangeComboVideoResolution() 
{
	// TODO: Add your control notification handler code here
	
	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	pMainDlg->m_nRecordResolutionPos[ nChannelNum ] = ((CComboBox*)GetDlgItem( IDC_COMBO_VIDEO_RESOLUTION ))->GetCurSel();

	ULONG i = pMainDlg->m_nRecordResolutionPos[ nChannelNum ];	
}

void CRecordPanel::OnSelchangeComboBitrate() 
{
	// TODO: Add your control notification handler code here	

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	pMainDlg->m_nRecordBiteRate[ nChannelNum ] = ((CComboBox*)GetDlgItem( IDC_COMBO_BITRATE ))->GetCurSel();

	ULONG i = pMainDlg->m_nRecordBiteRate[ nChannelNum ];
}

void CRecordPanel::OnSelchangeComboQuality() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	pMainDlg->m_nRecordQuality[ nChannelNum ] = ((CComboBox*)GetDlgItem( IDC_COMBO_QUALITY ))->GetCurSel();

	ULONG i = pMainDlg->m_nRecordQuality[ nChannelNum ];	
}

void CRecordPanel::OnSelchangeComboGop() 
{
	// TODO: Add your control notification handler code here	

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	pMainDlg->m_nRecordGOP[ nChannelNum ] = ((CComboBox*)GetDlgItem( IDC_COMBO_GOP ))->GetCurSel();

	ULONG i = pMainDlg->m_nRecordGOP[ nChannelNum ];	
}

void CRecordPanel::OnSelchangeComboScale() 
{
	// TODO: Add your control notification handler code here	

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	pMainDlg->m_nRecordScale[ nChannelNum ] = ((CComboBox*)GetDlgItem( IDC_COMBO_SCALE ))->GetCurSel();

	ULONG i = pMainDlg->m_nRecordScale[ nChannelNum ];	
}

void CRecordPanel::OnCheckGpu() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	pMainDlg->m_bRecordSupportGPU[ nChannelNum ] = ((CButton*)GetDlgItem( IDC_CHECK_GPU ))->GetCheck();

	ULONG i = pMainDlg->m_bRecordSupportGPU[ nChannelNum ];
}

void CRecordPanel::OnCheckDeinterlace() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	pMainDlg->m_bRecordAutoDeinterlace[ nChannelNum ] = ((CButton*)GetDlgItem( IDC_CHECK_DEINTERLACE ))->GetCheck();

	ULONG i = pMainDlg->m_bRecordAutoDeinterlace[ nChannelNum ];

	QCAP_SET_VIDEO_DEINTERLACE( pMainDlg->m_hVideoDevice[ nChannelNum ], i );
}
