// VideoInputPanel.cpp : implementation file
//

#include "stdafx.h"
#include "MultiRecoderDemo.h"
#include "VideoInputPanel.h"

#include "MultiRecoderDemoDlg.h"

#include "LivePropertyDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVideoInputPanel dialog


CVideoInputPanel::CVideoInputPanel(CWnd* pParent /*=NULL*/)
	: CDialog(CVideoInputPanel::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVideoInputPanel)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CVideoInputPanel::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVideoInputPanel)
	DDX_Control(pDX, IDC_STATIC_SHARPNESS, m_staticSharpness);
	DDX_Control(pDX, IDC_STATIC_SATURATION, m_staticSaturation);
	DDX_Control(pDX, IDC_STATIC_HUE, m_staticHue);
	DDX_Control(pDX, IDC_STATIC_CONSTRAST, m_staticContrast);
	DDX_Control(pDX, IDC_STATIC_BRIGHTNESS, m_staticBrightness);
	DDX_Control(pDX, IDC_SLIDER_SHARPNESS, m_sldSharpness);
	DDX_Control(pDX, IDC_SLIDER_SATURATION, m_sldSaturation);
	DDX_Control(pDX, IDC_SLIDER_HUE, m_sldHue);
	DDX_Control(pDX, IDC_SLIDER_CONSTRAST, m_sldConstrast);
	DDX_Control(pDX, IDC_SLIDER_BRIGHTNESS, m_sldBrightness);
	DDX_Control(pDX, IDC_STATIC_VIDEO_INPUT, m_stcClonePreview);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CVideoInputPanel, CDialog)
	//{{AFX_MSG_MAP(CVideoInputPanel)
	ON_BN_CLICKED(IDC_RADIO_INPUT_HDMI, OnRadioInputHdmi)
	ON_BN_CLICKED(IDC_RADIO_INPUT_DVID, OnRadioInputDvid)
	ON_BN_CLICKED(IDC_RADIO_INPUT_COMPONENTS, OnRadioInputComponents)
	ON_BN_CLICKED(IDC_RADIO_INPUT_DVIA, OnRadioInputDvia)
	ON_BN_CLICKED(IDC_RADIO_INPUT_SDI, OnRadioInputSdi)
	ON_BN_CLICKED(IDC_RADIO_INPUT_COMPOSITE, OnRadioInputComposite)
	ON_BN_CLICKED(IDC_RADIO_INPUT_SVIDEO, OnRadioInputSvideo)
	ON_BN_CLICKED(IDC_RADIO_INPUT_AUTO, OnRadioInputAuto)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_DEFAULT, OnButtonDefault)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_BRIGHTNESS, OnReleasedcaptureSliderBrightness)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_CONSTRAST, OnReleasedcaptureSliderConstrast)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_HUE, OnReleasedcaptureSliderHue)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_SATURATION, OnReleasedcaptureSliderSaturation)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_SHARPNESS, OnReleasedcaptureSliderSharpness)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVideoInputPanel message handlers

BOOL CVideoInputPanel::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	ULONG inputs = 0;

	// SETTING VIDEO INPUT
	//
	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] != 0 ) {

		QCAP_GET_VIDEO_INPUT( pMainDlg->m_hVideoDevice[ nChannelNum ], &inputs );

		if ( inputs == 0 ) { CheckDlgButton( IDC_RADIO_INPUT_COMPOSITE, BST_CHECKED ); }

		if ( inputs == 1 ) { CheckDlgButton( IDC_RADIO_INPUT_SVIDEO, BST_CHECKED ); }

		if ( inputs == 2 ) { CheckDlgButton( IDC_RADIO_INPUT_HDMI, BST_CHECKED ); }

		if ( inputs == 3 ) { CheckDlgButton( IDC_RADIO_INPUT_DVID, BST_CHECKED ); }

		if ( inputs == 4 ) { CheckDlgButton( IDC_RADIO_INPUT_COMPONENTS, BST_CHECKED ); }

		if ( inputs == 5 ) { CheckDlgButton( IDC_RADIO_INPUT_DVIA, BST_CHECKED ); }

		if ( inputs == 6 ) { CheckDlgButton( IDC_RADIO_INPUT_SDI, BST_CHECKED ); }

		if ( inputs == 7 ) { CheckDlgButton( IDC_RADIO_INPUT_AUTO, BST_CHECKED ); }


		// CREATE CLONE
		//				
		QCAP_CREATE_CLONE( pMainDlg->m_hVideoDevice[ nChannelNum ], m_stcClonePreview.m_hWnd, &pMainDlg->m_hCloneCapDev[ nChannelNum ] );

		if ( pMainDlg->m_hCloneCapDev[ nChannelNum ] != 0 ) {

			QCAP_RUN( pMainDlg->m_hCloneCapDev[ nChannelNum ] );

			QCAP_SET_AUDIO_VOLUME( pMainDlg->m_hCloneCapDev[ nChannelNum ], 0 );
		}
	}

	// SETTING VIDEO QUALITY 
	//
	m_sldBrightness.SetRange( 0, 255, TRUE );

	m_sldConstrast.SetRange( 0, 255, TRUE );

	m_sldHue.SetRange( 0, 255, TRUE );

	m_sldSaturation.SetRange( 0, 255, TRUE );

	m_sldSharpness.SetRange( 0, 255, TRUE );

	// SET VALUES 
	CHAR sz[ MAX_PATH ] = { 0 };

	QCAP_SET_VIDEO_BRIGHTNESS( pMainDlg->m_hVideoDevice[ nChannelNum ], pMainDlg->m_nBrightness[ nChannelNum ] );

	m_sldBrightness.SetPos( pMainDlg->m_nBrightness[ nChannelNum ] );

	itoa( pMainDlg->m_nBrightness[ nChannelNum ], sz, 10 );

	//m_staticBrightness = (LPTSTR)sz;
	m_staticBrightness.SetWindowText( (LPTSTR)sz );

	
	QCAP_SET_VIDEO_CONTRAST( pMainDlg->m_hVideoDevice[ nChannelNum ], pMainDlg->m_nConstrast[ nChannelNum ] );

	m_sldConstrast.SetPos( pMainDlg->m_nConstrast[ nChannelNum ] );

	itoa( pMainDlg->m_nConstrast[ nChannelNum ], sz, 10 );

	//m_staticContrast = (LPTSTR)sz;
	m_staticContrast.SetWindowText( (LPTSTR)sz );

	
	QCAP_SET_VIDEO_HUE( pMainDlg->m_hVideoDevice[ nChannelNum ], pMainDlg->m_nHue[ nChannelNum ] );

	m_sldHue.SetPos( pMainDlg->m_nHue[ nChannelNum ] );

	itoa( pMainDlg->m_nHue[ nChannelNum ], sz, 10 );

	//m_staticHue = (LPTSTR)sz;
	m_staticHue.SetWindowText( (LPTSTR)sz );


	QCAP_SET_VIDEO_SATURATION( pMainDlg->m_hVideoDevice[ nChannelNum ], pMainDlg->m_nSaturation[ nChannelNum ] );

	m_sldSaturation.SetPos( pMainDlg->m_nSaturation[ nChannelNum ] );

	itoa(  pMainDlg->m_nSaturation[ nChannelNum ], sz, 10 );

	//m_staticSaturation = (LPTSTR)sz;
	m_staticSaturation.SetWindowText( (LPTSTR)sz );


	QCAP_SET_VIDEO_SHARPNESS( pMainDlg->m_hVideoDevice[ nChannelNum ], pMainDlg->m_nSharpness[ nChannelNum ] );

	m_sldSharpness.SetPos( pMainDlg->m_nSharpness[ nChannelNum ] );

	itoa( pMainDlg->m_nSharpness[ nChannelNum ], sz, 10 );

	//m_staticSharpness = (LPTSTR)sz;
	m_staticSharpness.SetWindowText( (LPTSTR)sz );


	UpdateData( FALSE );
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CVideoInputPanel::OnRadioInputHdmi() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	QCAP_SET_VIDEO_INPUT( pMainDlg->m_hVideoDevice[ nChannelNum ], 0x00000002 );

	//CDialog::OnOK();	
}

void CVideoInputPanel::OnRadioInputDvid() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	QCAP_SET_VIDEO_INPUT( pMainDlg->m_hVideoDevice[ nChannelNum ], 0x00000003 );	
}

void CVideoInputPanel::OnRadioInputComponents() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	QCAP_SET_VIDEO_INPUT( pMainDlg->m_hVideoDevice[ nChannelNum ], 0x00000004 );	
}

void CVideoInputPanel::OnRadioInputDvia() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	QCAP_SET_VIDEO_INPUT( pMainDlg->m_hVideoDevice[ nChannelNum ], 0x00000005 );	
}

void CVideoInputPanel::OnRadioInputSdi() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	QCAP_SET_VIDEO_INPUT( pMainDlg->m_hVideoDevice[ nChannelNum ], 0x00000006 );	
}

void CVideoInputPanel::OnRadioInputComposite() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	QCAP_SET_VIDEO_INPUT( pMainDlg->m_hVideoDevice[ nChannelNum ], 0x00000000 );	
}

void CVideoInputPanel::OnRadioInputSvideo() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	QCAP_SET_VIDEO_INPUT( pMainDlg->m_hVideoDevice[ nChannelNum ], 0x00000001 );	
}

void CVideoInputPanel::OnRadioInputAuto() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	QCAP_SET_VIDEO_INPUT( pMainDlg->m_hVideoDevice[ nChannelNum ], 0x00000007 );	
}

void CVideoInputPanel::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;
	
	if ( pMainDlg->m_hCloneCapDev[ nChannelNum ] != 0 ) {

		QCAP_STOP( pMainDlg->m_hCloneCapDev[ nChannelNum ] );

		QCAP_DESTROY( pMainDlg->m_hCloneCapDev[ nChannelNum ] );

		pMainDlg->m_hCloneCapDev[ nChannelNum ] = 0;
	}
}

void CVideoInputPanel::OnOK() 
{
	// TODO: Add extra validation here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;
	
	m_pMainParent->SendMessage( WM_CLOSE );
	
	//m_pMainParent->DestroyWindow();

	CDialog::OnOK();
}

void CVideoInputPanel::OnButtonDefault() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] != NULL ) {

		QCAP_SET_VIDEO_BRIGHTNESS( pMainDlg->m_hVideoDevice[ nChannelNum ], 128 );

        m_sldBrightness.SetPos( 128 );

        m_staticBrightness.SetWindowText( _T("128") );

		pMainDlg->m_nBrightness[ nChannelNum ] = 128;


	
        QCAP_SET_VIDEO_CONTRAST( pMainDlg->m_hVideoDevice, 128 );

        m_sldConstrast.SetPos( 128 );

        //m_staticContrast = _T("128");
		m_staticContrast.SetWindowText( _T("128") );

		pMainDlg->m_nConstrast[ nChannelNum ] = 128;



        QCAP_SET_VIDEO_HUE( pMainDlg->m_hVideoDevice[ nChannelNum ], 128 );

        m_sldHue.SetPos( 128 );

        //m_staticHue = _T("128");
		m_staticHue.SetWindowText( _T("128") );

		pMainDlg->m_nHue[ nChannelNum ] = 128;



        QCAP_SET_VIDEO_SATURATION( pMainDlg->m_hVideoDevice[ nChannelNum ], 128 );

        m_sldSaturation.SetPos( 128 );

        //m_staticSaturation = _T("128");
		m_staticSaturation.SetWindowText( _T("128") );

		pMainDlg->m_nSaturation[ nChannelNum ] = 128;



        QCAP_SET_VIDEO_SHARPNESS( pMainDlg->m_hVideoDevice[ nChannelNum ], 128 );

        m_sldSharpness.SetPos( 128 );

        //m_staticSharpness = _T("128");
		m_staticSharpness.SetWindowText( _T("128") );
		
		pMainDlg->m_nSharpness[ nChannelNum ] = 128;	
	}			 

	UpdateData( FALSE );  	
}

void CVideoInputPanel::OnReleasedcaptureSliderBrightness(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	QCAP_SET_VIDEO_BRIGHTNESS( pMainDlg->m_hVideoDevice[ nChannelNum ], m_sldBrightness.GetPos() );

	CHAR sz[ MAX_PATH ] = { 0 };

	itoa(m_sldBrightness.GetPos(), sz, 10 );

	m_staticBrightness.SetWindowText( (LPTSTR)sz );

	pMainDlg->m_nBrightness[ nChannelNum ] = m_sldBrightness.GetPos();

	UpdateData( FALSE );		

	*pResult = 0;
}

void CVideoInputPanel::OnReleasedcaptureSliderConstrast(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	QCAP_SET_VIDEO_CONTRAST( pMainDlg->m_hVideoDevice[ nChannelNum ], m_sldConstrast.GetPos() );	

	CHAR sz[ MAX_PATH ] = { 0 };

	itoa( m_sldConstrast.GetPos(), sz, 10 );

	//m_staticContrast = (LPTSTR)sz;
	m_staticContrast.SetWindowText( (LPTSTR)sz );

	pMainDlg->m_nConstrast[ nChannelNum ] = m_sldConstrast.GetPos();

	UpdateData( FALSE );		

	*pResult = 0;
}

void CVideoInputPanel::OnReleasedcaptureSliderHue(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	QCAP_SET_VIDEO_HUE( pMainDlg->m_hVideoDevice[ nChannelNum ], m_sldHue.GetPos() );	

	CHAR sz[ MAX_PATH ] = { 0 };

	itoa( m_sldHue.GetPos(), sz, 10 );

	m_staticHue.SetWindowText( (LPTSTR)sz );

	pMainDlg->m_nHue[ nChannelNum ] = m_sldHue.GetPos();

	UpdateData( FALSE );

	*pResult = 0;
}

void CVideoInputPanel::OnReleasedcaptureSliderSaturation(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	QCAP_SET_VIDEO_SATURATION( pMainDlg->m_hVideoDevice[ nChannelNum ], m_sldSaturation.GetPos() );

	CHAR sz[ MAX_PATH ] = { 0 };

	itoa( m_sldSaturation.GetPos(), sz, 10 );

	m_staticSaturation.SetWindowText( (LPTSTR)sz );

	pMainDlg->m_nSaturation[ nChannelNum ] = m_sldSaturation.GetPos();

	UpdateData( FALSE );	

	*pResult = 0;
}

void CVideoInputPanel::OnReleasedcaptureSliderSharpness(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	QCAP_SET_VIDEO_SHARPNESS( pMainDlg->m_hVideoDevice[ nChannelNum ], m_sldSharpness.GetPos() );	

	CHAR sz[ MAX_PATH ] = { 0 };

	itoa( m_sldSharpness.GetPos(), sz, 10 );

	m_staticSharpness.SetWindowText( (LPTSTR)sz );

	pMainDlg->m_nSharpness[ nChannelNum ] = m_sldSharpness.GetPos();

	UpdateData( FALSE );	

	*pResult = 0;
}
