// ChannelWindow.cpp : implementation file
//

#include "stdafx.h"
#include "QMultiplexer.h"
#include "QMultiplexerDlg.h"
#include "ChannelWindow.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern VOID Dbg( CHAR* , ... );

/////////////////////////////////////////////////////////////////////////////
// CChannelWindow

CChannelWindow::CChannelWindow()
{
}

CChannelWindow::~CChannelWindow()
{
}


BEGIN_MESSAGE_MAP(CChannelWindow, CWnd)
	//{{AFX_MSG_MAP(CChannelWindow)
	ON_WM_ERASEBKGND()
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	ON_WM_CREATE()
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CChannelWindow message handlers

BOOL CChannelWindow::OnEraseBkgnd(CDC* pDC)
{
	// TODO: Add your message handler code here and/or call default

	CQMultiplexerDlg* pMainDlg = CQMultiplexerDlg::s_pCQMultiplexerDlgMainDlg;

	ULONG nChannelNum = GetDlgCtrlID() - 1;
	
	if( ( nChannelNum & 0xF0000000 ) != 0x00000000 ){ nChannelNum = nChannelNum & 0x000000FF; }		// DUE TO HAVING BACKGROUND AND FOREGROUND WINDOW
	
	if( nChannelNum == MIRROR_CHANNEL && pMainDlg->m_nWndowLayoutType == 2 ) { return TRUE; }		// 2012.07.25 @ mux 3x3 

	CRect rect_client; GetClientRect( &rect_client );

	// FILL IN THE TEXT
	//
	CFont font;

	ULONG nRation = ( GetSystemMetrics( SM_CXSCREEN ) / 2 ) / rect_client.Width();

	ULONG nMode = (GetSystemMetrics( SM_CXSCREEN ) / 2 ) % rect_client.Width();

	if ( nRation == 0 ) { nRation = 1; }		// IF FULL SCREEN
		
	ULONG nFontSize = ( 300 / nRation ) - nMode;
			
	font.CreatePointFont( nFontSize, TEXT( "Arial" ), NULL );

	pDC->SelectObject( &font );

	pDC->SetBkMode( TRANSPARENT );

	if( pMainDlg->m_hVideoDevice[ nChannelNum ] == 0 ) {
		
		CBrush brush_fill_rect( RGB( 192, 192, 192 ) );

		pDC->FillRect( &rect_client, &brush_fill_rect );

		pDC->SetTextColor( RGB( 0, 0, 0 ) );

		CString string = TEXT( "No Device" );

		pDC->DrawText( string, &rect_client, DT_SINGLELINE| DT_CENTER | DT_VCENTER );
	}
	else if ( pMainDlg->m_bNoSignal[ nChannelNum ] == 1 ) {		

		CBrush brush_fill_rect( RGB( 0, 0, 255) );

		pDC->FillRect( &rect_client, &brush_fill_rect );

		pDC->SetTextColor( RGB( 255, 255, 255 ) );

		CString string = TEXT( "No Source" );

		pDC->DrawText( string, &rect_client, DT_SINGLELINE| DT_CENTER | DT_VCENTER );
	}

	return TRUE;		

	return CWnd::OnEraseBkgnd(pDC); 
}

void CChannelWindow::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CQMultiplexerDlg* pMainDlg = (CQMultiplexerDlg*)AfxGetMainWnd();
	
	ULONG nChannelNum = GetDlgCtrlID() - 1;

	if( ( nChannelNum & 0xF0000000 ) != 0x00000000 ){ nChannelNum = nChannelNum & 0x000000FF; }

	pMainDlg->OnLButtonDown_CChannelWindow( nChannelNum, nFlags, point );

	CWnd::OnLButtonDown( nFlags, point );
}

void CChannelWindow::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	CQMultiplexerDlg* pMainDlg = (CQMultiplexerDlg*)AfxGetMainWnd();
	
	ULONG nChannelNum = GetDlgCtrlID() - 1;

	if( ( nChannelNum & 0xF0000000 ) != 0x00000000 ){ nChannelNum = nChannelNum & 0x000000FF; }

	ClientToScreen( &point );

	pMainDlg->OnRButtonDown_CChannelWindow( nChannelNum, point, this );	

	CWnd::OnRButtonDown(nFlags, point);
}

int CChannelWindow::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	
	return 0;
}

void CChannelWindow::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

	CQMultiplexerDlg* pMainDlg = (CQMultiplexerDlg* )AfxGetMainWnd();

	ULONG nChannelNum = GetDlgCtrlID() - 1;
	
	// TODO: Add your message handler code here
	
	// Do not call CWnd::OnPaint() for painting messages
}
