﻿Imports System.IO

Imports QCAP.NET

Public Class MySetupControl

    Public m_pMainForm As Form1

    Public m_hCapDev As UInt32 = 0 ' STREAM CAPTURE DEVICE

    Public m_strFormatChangedOutput As String = " INFO :  . . ."

    Public m_strCurrentDir As String 'CURRENT WORKING DIRECTORY

    Public m_bNoSignal As Boolean = True

    Public m_bIsRecord1 As Boolean = False

    Public m_bIsRecord2 As Boolean = False

    Public m_bAutoDeinterlace As Boolean = True

    Public m_bCheckedAVI_1 As Boolean = True

    Public m_bCheckedAVI_2 As Boolean = True

    Public m_bCheckedMP4_1 As Boolean = False

    Public m_bCheckedMP4_2 As Boolean = False

    Public m_bCheckedFLV_1 As Boolean = False

    Public m_bCheckedFLV_2 As Boolean = False

    Public m_strBmpName As String

    Public m_strJpgName As String

    Public m_strAviName1 As String

    Public m_strAviName2 As String

    Public m_cVideoInputDlg As MyVideoInputDlg

    Public m_cAudioInputDlg As MyAudioInputDlg

    Public m_cVideoPropertytDlg As MyVideoPropertyDlg

    Private Sub timerShowInfo_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles timerShowInfo.Tick

        m_staticDeviceFormatInformation.Text = m_strFormatChangedOutput

    End Sub

    Private Sub timerCheckSignal_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles timerCheckSignal.Tick

        m_hCapDev = m_pMainForm.m_hCapDev

        If m_hCapDev <> 0 Then

            If m_bIsRecord1 = True And m_bNoSignal = True Then

                EXPORTS.QCAP_STOP_RECORD(m_hCapDev, 0)

                m_bIsRecord1 = False

            End If

            If m_bIsRecord2 = True And m_bNoSignal = True Then

                EXPORTS.QCAP_STOP_RECORD(m_hCapDev, 1)

                m_bIsRecord2 = False

            End If

        End If

    End Sub

    Private Sub MySetupControl_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        m_cVideoInputDlg = New MyVideoInputDlg()

        m_cVideoInputDlg.m_pMainForm = Me

        m_cVideoInputDlg.Hide()

        m_cAudioInputDlg = New MyAudioInputDlg()

        m_cAudioInputDlg.m_pMainForm = Me

        m_cAudioInputDlg.Hide()

        m_cVideoPropertytDlg = New MyVideoPropertyDlg()

        m_cVideoPropertytDlg.m_pMainForm = Me

        m_cVideoPropertytDlg.Hide()

        'GET CURRENT DIRECTORY
        '
        m_strCurrentDir = Directory.GetCurrentDirectory()

        m_staticDeviceFormatInformation.Width = Me.Width - 30

        m_strBmpName = m_strCurrentDir + "\CH01.BMP"

        m_strJpgName = m_strCurrentDir + "\CH01.JPG"

        m_strAviName1 = m_strCurrentDir + "\CH01_1.AVI"

        m_strAviName2 = m_strCurrentDir + "\CH01_2.AVI"

        textBoxSnapshotBMP.Text = m_strBmpName

        textBoxSnapshotJPG.Text = m_strJpgName

        textBoxRecordAVI1.Text = m_strAviName1

        textBoxRecordAVI2.Text = m_strAviName2

        m_btnRecordStart1.Enabled = True

        m_btnRecordStop1.Enabled = False

        m_btnRecordStart2.Enabled = True

        m_btnRecordStop2.Enabled = False

        timerCheckSignal.Enabled = True

    End Sub

    Private Sub MySetupControl_FormClosed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed

    End Sub

    Private Sub m_checkShowCloneVideo_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkShowCloneVideo.Click

        Dim bShowCloneVideo As Boolean = m_checkShowCloneVideo.Checked

        If bShowCloneVideo = True Then

            m_pMainForm.ShowCloneVideo(True)

        Else

            m_pMainForm.ShowCloneVideo(False)

        End If

    End Sub

    Private Sub m_checkAutoDeinterlace_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkAutoDeinterlace.Click

        m_bAutoDeinterlace = m_checkAutoDeinterlace.Checked

        m_hCapDev = m_pMainForm.m_hCapDev

        If m_hCapDev <> 0 Then

            If m_bAutoDeinterlace = True Then

                EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev, 1)

            Else

                EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev, 0)

            End If

        End If

    End Sub

    Private Sub m_btnSnapshotBMP_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnSnapshotBMP.Click

        m_hCapDev = m_pMainForm.m_hCapDev

        If m_hCapDev <> 0 Then

            Dim strBmpName As String = m_strCurrentDir + "\CH01.BMP"

            EXPORTS.QCAP_SNAPSHOT_BMP(m_hCapDev, strBmpName)

        End If

    End Sub

    Private Sub m_btnSnapshotJPG_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnSnapshotJPG.Click

        m_hCapDev = m_pMainForm.m_hCapDev

        If m_hCapDev <> 0 Then

            Dim strJpgName As String = m_strCurrentDir + "\CH01.JPG"

            EXPORTS.QCAP_SNAPSHOT_JPG(m_hCapDev, strJpgName, 80)

        End If

    End Sub

    Private Sub m_btnRecordStop1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStop1.Click

        m_hCapDev = m_pMainForm.m_hCapDev

        m_btnRecordStart1.Enabled = True

        m_btnRecordStop1.Enabled = False

        If m_hCapDev <> 0 Then

            EXPORTS.QCAP_STOP_RECORD(m_hCapDev, 0)

            m_bIsRecord1 = False

        End If

    End Sub

    Private Sub m_btnRecordStop2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStop2.Click

        m_hCapDev = m_pMainForm.m_hCapDev

        m_btnRecordStart2.Enabled = True

        m_btnRecordStop2.Enabled = False

        If m_hCapDev <> 0 Then

            EXPORTS.QCAP_STOP_RECORD(m_hCapDev, 1)

            m_bIsRecord2 = False

        End If

    End Sub

    Private Sub m_checkAVI_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkAVI_1.Click

        m_checkAVI_1.Checked = True

        m_checkMP4_1.Checked = False

        m_checkFLV_1.Checked = False

        m_bCheckedAVI_1 = True

        m_bCheckedMP4_1 = False

        m_bCheckedFLV_1 = False

        m_strAviName1 = m_strAviName1.Replace(".MP4", ".AVI")

        m_strAviName1 = m_strAviName1.Replace(".FLV", ".AVI")

        textBoxRecordAVI1.Text = m_strAviName1

    End Sub

    Private Sub m_checkMP4_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkMP4_1.Click

        m_checkAVI_1.Checked = False

        m_checkMP4_1.Checked = True

        m_checkFLV_1.Checked = False

        m_bCheckedAVI_1 = False

        m_bCheckedMP4_1 = True

        m_bCheckedFLV_1 = False

        m_strAviName1 = m_strAviName1.Replace(".AVI", ".MP4")

        m_strAviName1 = m_strAviName1.Replace(".FLV", ".MP4")

        textBoxRecordAVI1.Text = m_strAviName1

    End Sub

    Private Sub m_checkAVI_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkAVI_2.Click

        m_checkAVI_2.Checked = True

        m_checkMP4_2.Checked = False

        m_checkFLV_2.Checked = False

        m_bCheckedAVI_2 = True

        m_bCheckedMP4_2 = False

        m_bCheckedFLV_2 = False

        m_strAviName2 = m_strAviName2.Replace(".MP4", ".AVI")

        m_strAviName2 = m_strAviName2.Replace(".FLV", ".AVI")

        textBoxRecordAVI2.Text = m_strAviName2

    End Sub

    Private Sub m_checkMP4_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkMP4_2.Click

        m_checkAVI_2.Checked = False

        m_checkMP4_2.Checked = True

        m_checkFLV_2.Checked = False

        m_bCheckedAVI_2 = False

        m_bCheckedMP4_2 = True

        m_bCheckedFLV_2 = False

        m_strAviName2 = m_strAviName2.Replace(".AVI", ".MP4")

        m_strAviName2 = m_strAviName2.Replace(".FLV", ".MP4")

        textBoxRecordAVI2.Text = m_strAviName2

    End Sub

    Private Sub m_btnRecordStart1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStart1.Click

        m_hCapDev = m_pMainForm.m_hCapDev

        m_btnRecordStart1.Enabled = False

        m_btnRecordStop1.Enabled = True

        If m_hCapDev <> 0 Then

            If m_bCheckedAVI_1 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev, 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM)

            End If

            If m_bCheckedMP4_1 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev, 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

            If m_bCheckedFLV_1 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev, 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

            EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev, 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_HARDWARE, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0, EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_OFF)

            EXPORTS.QCAP_START_RECORD(m_hCapDev, 0, m_strAviName1)

            m_bIsRecord1 = True

        End If

    End Sub

    Private Sub m_btnRecordStart2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStart2.Click

        m_hCapDev = m_pMainForm.m_hCapDev

        m_btnRecordStart2.Enabled = False

        m_btnRecordStop2.Enabled = True

        If m_hCapDev <> 0 Then

            If m_bCheckedAVI_2 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev, 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM)

            End If

            If m_bCheckedMP4_2 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev, 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

            If m_bCheckedFLV_2 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev, 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

            EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev, 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_HARDWARE, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_1_2)

            EXPORTS.QCAP_START_RECORD(m_hCapDev, 1, m_strAviName2)

            m_bIsRecord2 = True

        End If

    End Sub

    Private Sub m_btnVideoInput_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnVideoInput.Click

        m_cVideoInputDlg.m_hCapDev = m_pMainForm.m_hCapDev

        m_cVideoInputDlg.Show()

    End Sub

    Private Sub m_btnAudioInput_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnAudioInput.Click

        m_cAudioInputDlg.m_hCapDev = m_pMainForm.m_hCapDev

        m_cAudioInputDlg.Show()

    End Sub

    Private Sub m_btnVideoQuality_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnVideoQuality.Click

        m_cVideoPropertytDlg.m_hCapDev = m_pMainForm.m_hCapDev

        m_cVideoPropertytDlg.Show()

    End Sub

    Private Sub m_checkFLV_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkFLV_1.Click

        m_checkAVI_1.Checked = False

        m_checkMP4_1.Checked = False

        m_checkFLV_1.Checked = True

        m_bCheckedAVI_1 = False

        m_bCheckedMP4_1 = False

        m_bCheckedFLV_1 = True

        m_strAviName1 = m_strAviName1.Replace(".AVI", ".FLV")

        m_strAviName1 = m_strAviName1.Replace(".MP4", ".FLV")

        textBoxRecordAVI1.Text = m_strAviName1

    End Sub

    Private Sub m_checkFLV_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkFLV_2.Click

        m_checkAVI_2.Checked = False

        m_checkMP4_2.Checked = False

        m_checkFLV_2.Checked = True

        m_bCheckedAVI_2 = False

        m_bCheckedMP4_2 = False

        m_bCheckedFLV_2 = True

        m_strAviName2 = m_strAviName2.Replace(".AVI", ".FLV")

        m_strAviName2 = m_strAviName2.Replace(".MP4", ".FLV")

        textBoxRecordAVI2.Text = m_strAviName2

    End Sub

End Class