﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

using QCAP.NET;

namespace StreamCatcherDemo
{
    public partial class MyShareRecordAdvancedSettingsDlg : Form
    {
        [DllImport("kernel32.dll", CharSet = CharSet.Auto)]
        public static extern void OutputDebugString(string message);

        public Form1 m_pMainForm;

        public uint i = 0;

        public string m_strCurrentDir = "";

        public string m_strRecordFilePath, m_strRecordFileNameRule;

        public string m_strSnapshotFilePath;        

        public bool m_bSupportGPU;

        public bool m_bCheckedAVI, m_bCheckedMP4;

        public uint m_nVideoStandard;

        public double m_dFrameRate;

        public uint m_nEncoderType, m_nEncoderFormat;

        public uint m_nEncoderWidth, m_nEncoderHeight;

        public uint m_nAudioEncoderFormat;

        public uint m_nRecordMode, m_nQuality, m_nBitRate, m_nGOP, m_DownloadScaleMode;

        public uint m_nContinuousSnapshots, m_nContinuousSnapshotsDuration;

        // OSD
        //
        public string m_pszString;

        public string m_pszFontFamilyName;

        public Color m_clrFontForeground, m_clrFontBackground;

        public uint m_dwBackgroundColorTransparent;

        public uint m_nOsdNum1, m_nOsdNum2, m_nOsdNum3;

        public uint m_dwFontColor;

        public uint m_dwFontColorTransparent;

        public uint m_nFontSize, m_nFontStyle;

        public uint m_xoffset1, m_xoffset2, m_xoffset3;

        public uint m_yoffset1, m_yoffset2, m_yoffset3;

        public uint m_width1, m_width2, m_width3;

        public uint m_height1, m_height2, m_height3;

        public uint m_nTransparent1, m_nTransparent2, m_nTransparent3;

        public string m_strPicturePath;

        public Bitmap m_PicImage;

        // CONVERT COLOR TO UINT
        //
        private uint ColorToUInt(Color color)
        {
            return (uint)((color.A << 24) | (color.R << 16) | (color.G << 8) | (color.B << 0));
        }

        // CONVERT UINT TO COLORs
        //
        private Color UIntToColor(uint color)
        {
            byte a = (byte)(color >> 24);
            byte r = (byte)(color >> 16);
            byte g = (byte)(color >> 8);
            byte b = (byte)(color >> 0);

            return Color.FromArgb(a, r, g, b);
        }

        public MyShareRecordAdvancedSettingsDlg()
        {
            InitializeComponent();
        }

        private void MyShareRecordAdvancedSettingsDlg_Load(object sender, EventArgs e)
        {
            // GET CURRENT DIRECTORY
            //
            m_strCurrentDir = Directory.GetCurrentDirectory();

            textBoxRecordPath.Text = m_strCurrentDir;

            m_strRecordFilePath = m_strCurrentDir;

            m_bSupportGPU = false;

            m_bCheckedAVI = true; m_bCheckedMP4 = false;

            m_nContinuousSnapshots = 3;

            m_nContinuousSnapshotsDuration = 10;

            m_nVideoStandard = 0;            

            m_dFrameRate = 30.0;            

            m_nEncoderWidth = 1920; m_nEncoderHeight = 1080;

            m_nEncoderType = (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE;            

            m_nEncoderFormat = (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264;            

            m_nAudioEncoderFormat = (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM;            

            m_nRecordMode = (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR;            

            m_DownloadScaleMode = (uint)EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_OFF;

            m_nQuality = 8000;            

            m_nBitRate = 12582912;            

            m_nGOP = 30;

            m_pszString = "YUAN";

            m_pszFontFamilyName = "Arial";

            m_nOsdNum1 = 0; m_nOsdNum2 = 0; m_nOsdNum3 = 0;

            m_dwFontColor = 0;

            m_nFontSize = 0;

            m_nFontStyle = (uint)EXPORTS.FontStyleEnum.QCAP_FONT_STYLE_REGULAR;

            m_xoffset1 = 0; m_xoffset2 = 0; m_xoffset3 = 0;

            m_yoffset1 = 0; m_yoffset2 = 0; m_yoffset3 = 0;

            m_width1 = 320; m_width2 = 320; m_width3 = 320;

            m_height1 = 240; m_height2 = 240; m_height3 = 240;

            m_nTransparent1 = 255; m_nTransparent2 = 255; m_nTransparent3 = 255;

            m_strPicturePath = "";

            m_PicImage = null;

            m_dwFontColorTransparent = 0;

            m_dwBackgroundColorTransparent = 0;

            comboVideoStandard.SelectedIndex = 0;

            comboFrameRate.SelectedIndex = 0;

            comboVideoFormat.SelectedIndex = 0;

            comboAudioFormat.SelectedIndex = 0;

            comboRecordMode.SelectedIndex = 0;

            comboBitrate.SelectedIndex = 0;

            comboQuality.SelectedIndex = 0;

            comboGOP.SelectedIndex = 29;          

            comboxOSDLayer1.SelectedIndex = 0;

            comboxFontSize1.SelectedIndex = 9;

            comboxOSDLayer2.SelectedIndex = 1;

            comboBoxResolution.SelectedIndex = 0;

            comboxFontColorTransparent.SelectedIndex = 0;

            comboxBackgroundColorTransparent.SelectedIndex = 0;
        }

        private void MyShareRecordAdvancedSettingsDlg_FormClosed(object sender, FormClosedEventArgs e)
        {

        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            Hide();
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            Hide();

            m_pMainForm.m_bShareSupportGPU = m_bSupportGPU;

            m_pMainForm.m_bShareCheckedAVI = m_bCheckedAVI;

            m_pMainForm.m_bShareCheckedMP4 = m_bCheckedMP4;

            m_pMainForm.m_nShareVideoStandard = m_nVideoStandard;
           
           m_pMainForm.m_dShareFrameRate = m_dFrameRate;

           m_pMainForm.m_nShareEncoderWidth = m_nEncoderWidth;

           m_pMainForm.m_nShareEncoderHeight = m_nEncoderHeight;

            m_pMainForm.m_nShareEncoderType = m_nEncoderType;

           m_pMainForm.m_nShareEncoderFormat = m_nEncoderFormat;

           m_pMainForm.m_nShareAudioEncoderFormat = m_nAudioEncoderFormat;

           m_pMainForm.m_nShareRecordMode = m_nRecordMode;

           m_pMainForm.m_ShareDownloadScaleMode = m_DownloadScaleMode;

           m_pMainForm.m_nShareQuality = m_nQuality;

           m_pMainForm.m_nShareBitRate = m_nBitRate;

           m_pMainForm.m_nShareGOP = m_nGOP;

           m_pMainForm.m_strShareRecordFilePath = m_strRecordFilePath;

           if (m_bSupportGPU)
           {
               m_nEncoderType = (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK;

               m_pMainForm.m_nShareEncoderType = m_nEncoderType;
           }
           else
           {
               m_nEncoderType = (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE;

               m_pMainForm.m_nShareEncoderType = m_nEncoderType;
           }                         
        }

        private void m_checkAVI_Click(object sender, EventArgs e)
        {
            m_checkAVI.Checked = true;

            m_checkMP4.Checked = false;

            m_bCheckedAVI = true;

            m_bCheckedMP4 = false; 
        }

        private void m_checkMP4_Click(object sender, EventArgs e)
        {
            m_checkAVI.Checked = false;

            m_checkMP4.Checked = true;

            m_bCheckedAVI = false;

            m_bCheckedMP4 = true;
        }

        private void btnBrowseRecordPath_Click(object sender, EventArgs e)
        {
            using (FolderBrowserDialog dialog = new FolderBrowserDialog())
            {
                dialog.Description = "Open a folder to save record files";

                dialog.ShowNewFolderButton = false;

                dialog.RootFolder = Environment.SpecialFolder.MyComputer;

                m_strRecordFilePath = m_pMainForm.m_strShareRecordFilePath;

                dialog.SelectedPath = m_strRecordFilePath;

                if (dialog.ShowDialog() == DialogResult.OK)
                {
                    m_strRecordFilePath = dialog.SelectedPath;

                    m_pMainForm.m_strShareRecordFilePath = m_strRecordFilePath;

                    textBoxRecordPath.Text = m_strRecordFilePath;
                }
            }
        }

        private void comboVideoStandard_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboVideoStandard.SelectedIndex == 0) // NTSC
            {
                m_nVideoStandard = 0;

                comboFrameRate.Items.Clear();

                comboFrameRate.Items.Add("30.0 (fps)");

                comboFrameRate.Items.Add("15.0 (fps)");

                comboFrameRate.Items.Add(" 7.5 (fps)");

                comboFrameRate.SelectedIndex = 0;

                comboBoxResolution.Items.Clear();

                comboBoxResolution.Items.Add("1920 x 1080 ( HD 1080p Resolution ) ");
                comboBoxResolution.Items.Add("1280 x   720 ( HD 1080p Resolution ) ");
                comboBoxResolution.Items.Add("  720 x   480 ( DVD Resolution )");
                comboBoxResolution.Items.Add("  704 x   480 ( DVD Resolution )");
                comboBoxResolution.Items.Add("  640 x   480 ( VGA Resolution )");
                comboBoxResolution.Items.Add("  360 x   240 ( VCD Resolution )");
                comboBoxResolution.Items.Add("  352 x   240 ( VCD Resolution )");
                comboBoxResolution.Items.Add("  320 x   240 ( VCD Resolution )");

                comboBoxResolution.SelectedIndex = 0;
            }

            if (comboVideoStandard.SelectedIndex == 1) // PAL
            {
                m_nVideoStandard = 1;

                comboFrameRate.Items.Clear();

                comboFrameRate.Items.Add("25.0 (fps)");

                comboFrameRate.Items.Add("12.5 (fps)");

                comboFrameRate.Items.Add(" 6.25 (fps)");

                comboFrameRate.SelectedIndex = 0;

                comboBoxResolution.Items.Clear();

                comboBoxResolution.Items.Add("1920 x 1080 ( HD 1080p Resolution ) ");
                comboBoxResolution.Items.Add("1280 x   720 ( HD 1080p Resolution ) ");
                comboBoxResolution.Items.Add("  720 x   576 ( DVD Resolution )");
                comboBoxResolution.Items.Add("  704 x   576 ( DVD Resolution )");
                comboBoxResolution.Items.Add("  640 x   576 ( VGA Resolution )");
                comboBoxResolution.Items.Add("  360 x   288 ( VCD Resolution )");
                comboBoxResolution.Items.Add("  352 x   288 ( VCD Resolution )");
                comboBoxResolution.Items.Add("  320 x   288 ( VCD Resolution )");

                comboBoxResolution.SelectedIndex = 0;
            }            
        }

        private void comboFrameRate_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboVideoStandard.SelectedIndex == 0)
            {
                if (comboFrameRate.SelectedIndex == 0) { m_dFrameRate = 30.0; }

                if (comboFrameRate.SelectedIndex == 1) { m_dFrameRate = 15.0; }

                if (comboFrameRate.SelectedIndex == 2) { m_dFrameRate = 7.5; }
            }

            if (comboVideoStandard.SelectedIndex == 1)
            {
                if (comboFrameRate.SelectedIndex == 0) { m_dFrameRate = 25.0; }

                if (comboFrameRate.SelectedIndex == 1) { m_dFrameRate = 12.5; }

                if (comboFrameRate.SelectedIndex == 2) { m_dFrameRate = 6.25; }
            }   
        }

        private void comboVideoFormat_SelectedIndexChanged(object sender, EventArgs e)
        {
            m_nEncoderFormat = (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264;
        }

        private void comboAudioFormat_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboAudioFormat.SelectedIndex == 0)
            {
                m_nAudioEncoderFormat = (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM;
            }

            if (comboAudioFormat.SelectedIndex == 1)
            {
                m_nAudioEncoderFormat = (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC;
            }   
        }

        private void comboBoxResolution_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboBoxResolution.SelectedIndex == 0) { m_nEncoderWidth = 1920; m_nEncoderHeight = 1080; }

            if (comboBoxResolution.SelectedIndex == 1) { m_nEncoderWidth = 1280; m_nEncoderHeight = 720; }

            if (comboBoxResolution.SelectedIndex == 2 && comboVideoStandard.SelectedIndex == 0) { m_nEncoderWidth = 720; m_nEncoderHeight = 480; }

            if (comboBoxResolution.SelectedIndex == 3 && comboVideoStandard.SelectedIndex == 0) { m_nEncoderWidth = 704; m_nEncoderHeight = 480; }

            if (comboBoxResolution.SelectedIndex == 4 && comboVideoStandard.SelectedIndex == 0) { m_nEncoderWidth = 640; m_nEncoderHeight = 480; }

            if (comboBoxResolution.SelectedIndex == 5 && comboVideoStandard.SelectedIndex == 0) { m_nEncoderWidth = 360; m_nEncoderHeight = 240; }

            if (comboBoxResolution.SelectedIndex == 6 && comboVideoStandard.SelectedIndex == 0) { m_nEncoderWidth = 352; m_nEncoderHeight = 240; }

            if (comboBoxResolution.SelectedIndex == 7 && comboVideoStandard.SelectedIndex == 0) { m_nEncoderWidth = 320; m_nEncoderHeight = 240; }

            if (comboBoxResolution.SelectedIndex == 2 && comboVideoStandard.SelectedIndex == 1) { m_nEncoderWidth = 720; m_nEncoderHeight = 576; }

            if (comboBoxResolution.SelectedIndex == 3 && comboVideoStandard.SelectedIndex == 1) { m_nEncoderWidth = 704; m_nEncoderHeight = 576; }

            if (comboBoxResolution.SelectedIndex == 4 && comboVideoStandard.SelectedIndex == 1) { m_nEncoderWidth = 640; m_nEncoderHeight = 576; }

            if (comboBoxResolution.SelectedIndex == 5 && comboVideoStandard.SelectedIndex == 1) { m_nEncoderWidth = 360; m_nEncoderHeight = 288; }

            if (comboBoxResolution.SelectedIndex == 6 && comboVideoStandard.SelectedIndex == 1) { m_nEncoderWidth = 352; m_nEncoderHeight = 288; }

            if (comboBoxResolution.SelectedIndex == 7 && comboVideoStandard.SelectedIndex == 1) { m_nEncoderWidth = 320; m_nEncoderHeight = 288; }            
        }

        private void comboRecordMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboRecordMode.SelectedIndex == 0) { m_nRecordMode = (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR; }

            if (comboRecordMode.SelectedIndex == 1) { m_nRecordMode = (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_VBR; }
        }

        private void comboBitrate_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboBitrate.SelectedIndex == 0) { m_nBitRate = 12582912; }

            if (comboBitrate.SelectedIndex == 1) { m_nBitRate = 10485760; }

            if (comboBitrate.SelectedIndex == 2) { m_nBitRate = 8388608; }

            if (comboBitrate.SelectedIndex == 3) { m_nBitRate = 6291456; }

            if (comboBitrate.SelectedIndex == 4) { m_nBitRate = 4194304; }

            if (comboBitrate.SelectedIndex == 5) { m_nBitRate = 3145728; }

            if (comboBitrate.SelectedIndex == 6) { m_nBitRate = 2097152; }

            if (comboBitrate.SelectedIndex == 7) { m_nBitRate = 1572864; }

            if (comboBitrate.SelectedIndex == 8) { m_nBitRate = 1048576; }

            if (comboBitrate.SelectedIndex == 9) { m_nBitRate = 786432; }

            if (comboBitrate.SelectedIndex == 10) { m_nBitRate = 524288; }

            if (comboBitrate.SelectedIndex == 11) { m_nBitRate = 262144; }

            if (comboBitrate.SelectedIndex == 12) { m_nBitRate = 131072; }

            if (comboBitrate.SelectedIndex == 13) { m_nBitRate = 65536; }
        }

        private void comboQuality_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboQuality.SelectedIndex == 0) { m_nQuality = 10000; }

            if (comboQuality.SelectedIndex == 1) { m_nQuality = 9500; }

            if (comboQuality.SelectedIndex == 2) { m_nQuality = 9000; }

            if (comboQuality.SelectedIndex == 3) { m_nQuality = 8500; }

            if (comboQuality.SelectedIndex == 4) { m_nQuality = 8000; }

            if (comboQuality.SelectedIndex == 5) { m_nQuality = 7500; }

            if (comboQuality.SelectedIndex == 6) { m_nQuality = 7000; }

            if (comboQuality.SelectedIndex == 7) { m_nQuality = 6500; }

            if (comboQuality.SelectedIndex == 8) { m_nQuality = 6000; }

            if (comboQuality.SelectedIndex == 9) { m_nQuality = 5500; }

            if (comboQuality.SelectedIndex == 10) { m_nQuality = 5000; }

            if (comboQuality.SelectedIndex == 11) { m_nQuality = 4500; }

            if (comboQuality.SelectedIndex == 12) { m_nQuality = 4000; }

            if (comboQuality.SelectedIndex == 13) { m_nQuality = 3500; }

            if (comboQuality.SelectedIndex == 14) { m_nQuality = 3000; }

            if (comboQuality.SelectedIndex == 15) { m_nQuality = 2500; }

            if (comboQuality.SelectedIndex == 16) { m_nQuality = 2000; }

            if (comboQuality.SelectedIndex == 17) { m_nQuality = 1500; }

            if (comboQuality.SelectedIndex == 18) { m_nQuality = 1000; }

            if (comboQuality.SelectedIndex == 19) { m_nQuality = 500; }

            if (comboQuality.SelectedIndex == 20) { m_nQuality = 0; } 
        }

        private void comboQuality_SelectedIndexChanged_1(object sender, EventArgs e)
        {
            if (comboQuality.SelectedIndex == 0) { m_nQuality = 10000; }

            if (comboQuality.SelectedIndex == 1) { m_nQuality = 9500; }

            if (comboQuality.SelectedIndex == 2) { m_nQuality = 9000; }

            if (comboQuality.SelectedIndex == 3) { m_nQuality = 8500; }

            if (comboQuality.SelectedIndex == 4) { m_nQuality = 8000; }

            if (comboQuality.SelectedIndex == 5) { m_nQuality = 7500; }

            if (comboQuality.SelectedIndex == 6) { m_nQuality = 7000; }

            if (comboQuality.SelectedIndex == 7) { m_nQuality = 6500; }

            if (comboQuality.SelectedIndex == 8) { m_nQuality = 6000; }

            if (comboQuality.SelectedIndex == 9) { m_nQuality = 5500; }

            if (comboQuality.SelectedIndex == 10) { m_nQuality = 5000; }

            if (comboQuality.SelectedIndex == 11) { m_nQuality = 4500; }

            if (comboQuality.SelectedIndex == 12) { m_nQuality = 4000; }

            if (comboQuality.SelectedIndex == 13) { m_nQuality = 3500; }

            if (comboQuality.SelectedIndex == 14) { m_nQuality = 3000; }

            if (comboQuality.SelectedIndex == 15) { m_nQuality = 2500; }

            if (comboQuality.SelectedIndex == 16) { m_nQuality = 2000; }

            if (comboQuality.SelectedIndex == 17) { m_nQuality = 1500; }

            if (comboQuality.SelectedIndex == 18) { m_nQuality = 1000; }

            if (comboQuality.SelectedIndex == 19) { m_nQuality = 500; }

            if (comboQuality.SelectedIndex == 20) { m_nQuality = 0; }
        }

        private void comboGOP_SelectedIndexChanged(object sender, EventArgs e)
        {
            m_nGOP = (uint)comboGOP.SelectedIndex + 1;
        }        

        private void m_checkGPU_Click(object sender, EventArgs e)
        {
            m_bSupportGPU = m_checkGPU.Checked;
        }

        private void comboxFontSize1_SelectedIndexChanged(object sender, EventArgs e)
        {
            m_nFontSize = Convert.ToUInt32(comboxFontSize1.Text);
        }

        private void labelOSDFontColor_Click(object sender, EventArgs e)
        {
            ColorDialog ColorDlg = new ColorDialog();

            ColorDlg.AllowFullOpen = true;

            // SET INITIAL COLOR TO THE CURRENT OSD BACKGROUND COLOR
            //
            ColorDlg.Color = labelOSDFontColor.BackColor;

            // UPDATE THE TEXTBOX COLOR IF USER CLICK OK
            //
            if (ColorDlg.ShowDialog() == DialogResult.OK)
            {
                labelOSDFontColor.BackColor = ColorDlg.Color;

                m_clrFontForeground = ColorDlg.Color;

                txtBoxTypeString.ForeColor = m_clrFontForeground;
            }
        }

        private void labelOSDBackgroundColor_Click(object sender, EventArgs e)
        {
            ColorDialog ColorDlg = new ColorDialog();

            ColorDlg.AllowFullOpen = true;

            // SET INITIAL COLOR TO THE CURRENT OSD BACKGROUND COLOR
            //
            ColorDlg.Color = labelOSDBackgroundColor.BackColor;

            // UPDATE THE TEXTBOX COLOR IF USER CLICK OK
            //
            if (ColorDlg.ShowDialog() == DialogResult.OK)
            {
                labelOSDBackgroundColor.BackColor = ColorDlg.Color;

                m_clrFontBackground = ColorDlg.Color;

                txtBoxTypeString.BackColor = m_clrFontBackground;
            }
        }

        private void btnChangeFont_Click(object sender, EventArgs e)
        {
            fontDialog1.Color = txtBoxTypeString.ForeColor;

            if (fontDialog1.ShowDialog() != DialogResult.Cancel)
            {
                txtBoxTypeString.Font = new Font(fontDialog1.Font.FontFamily, 12, fontDialog1.Font.Style);

                txtBoxTypeString.ForeColor = fontDialog1.Color;

                labelOSDFontColor.BackColor = txtBoxTypeString.ForeColor;
            }
        }

        private void btnApplyOSDText_Click(object sender, EventArgs e)
        {
            m_nOsdNum1 = (uint)comboxOSDLayer1.SelectedIndex;

            m_xoffset1 = Convert.ToUInt32(txtBox_Xoffset1.Text);

            m_yoffset1 = Convert.ToUInt32(txtBox_Yoffset1.Text);

            m_width1 = Convert.ToUInt32(txtBox_width1.Text);

            m_height1 = Convert.ToUInt32(txtBox_height1.Text);

            m_dwFontColor = ColorToUInt(txtBoxTypeString.ForeColor);

            m_dwFontColor = m_dwFontColor & 0x00FFFFFF;
            
            uint dwBackgroundColor = 0;

            dwBackgroundColor = ColorToUInt(m_clrFontBackground);

            dwBackgroundColor = dwBackgroundColor & 0x00FFFFFF;

            m_dwBackgroundColorTransparent= Convert.ToUInt32(comboxBackgroundColorTransparent.SelectedIndex);

            m_dwBackgroundColorTransparent = m_dwBackgroundColorTransparent << 24;

            dwBackgroundColor = dwBackgroundColor | m_dwBackgroundColorTransparent;

            m_pszFontFamilyName = txtBoxTypeString.Font.FontFamily.Name;

            m_nFontStyle = (uint)txtBoxTypeString.Font.Style;
          
            Font txtFont = txtBoxTypeString.Font;

            bool bBold = txtFont.Bold;

            if (bBold) { m_nFontStyle |= (uint)EXPORTS.FontStyleEnum.QCAP_FONT_STYLE_BOLD; }

            bool bItalic = txtFont.Italic;

            if (bItalic) { m_nFontStyle |= (uint)EXPORTS.FontStyleEnum.QCAP_FONT_STYLE_ITALIC; }

            bool bStrikeout = txtFont.Strikeout;

            if (bStrikeout) { m_nFontStyle |= (uint)EXPORTS.FontStyleEnum.QCAP_FONT_STYLE_STRIKEOUT; }

            bool bUnderline = txtFont.Underline;

            if (bUnderline) { m_nFontStyle |= (uint)EXPORTS.FontStyleEnum.QCAP_FONT_STYLE_UNDERLINE; }

            m_nFontSize = Convert.ToUInt32(comboxFontSize1.Text);

            m_nTransparent1 = Convert.ToUInt32(txtBox_Transparent1.Text);

            m_dwFontColorTransparent = Convert.ToUInt32(comboxFontColorTransparent.SelectedIndex);

            m_dwFontColorTransparent = m_dwFontColorTransparent << 24;

            m_dwFontColor = m_dwFontColor | m_dwFontColorTransparent;

            m_pszString = txtBoxTypeString.Text;

            EXPORTS.QCAP_SET_OSD_SHARE_RECORD_TEXT(0, m_nOsdNum1, (int)m_xoffset1, (int)m_yoffset1, (int)m_width1, (int)m_height1, ref m_pszString, ref m_pszFontFamilyName, m_nFontStyle, m_nFontSize, m_dwFontColor, dwBackgroundColor, m_nTransparent1);          
        }

        private void btnApplyOSDPic_Click(object sender, EventArgs e)
        {
            m_nOsdNum2 = (uint)comboxOSDLayer2.SelectedIndex;

            m_xoffset2 = Convert.ToUInt32(txtBox_Xoffset2.Text);

            m_yoffset2 = Convert.ToUInt32(txtBox_Yoffset2.Text);

            m_width2 = Convert.ToUInt32(txtBox_width2.Text);

            m_height2 = Convert.ToUInt32(txtBox_height2.Text);

            m_nTransparent2 = Convert.ToUInt32(txtBox_Transparent2.Text);

            EXPORTS.QCAP_SET_OSD_SHARE_RECORD_PICTURE(0, m_nOsdNum2, (int)m_xoffset2, (int)m_yoffset2, (int)m_width2, (int)m_height2, ref m_strPicturePath, m_nTransparent2);          
        }

        private void btnBrowsePicPath_Click(object sender, EventArgs e)
        {
            Stream fileStream;

            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = "D:\\";

            openFileDialog1.Filter = "Image Files (*.bmp;*.png;*.jpg)|*.bmp;*.png;*.jpg|All Files (*.*)|*.*||";

            openFileDialog1.FilterIndex = 0;

            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                if ((fileStream = openFileDialog1.OpenFile()) != null)
                {
                    txtBoxPicPath.Text = openFileDialog1.FileName;

                    m_strPicturePath = txtBoxPicPath.Text;

                    if (m_PicImage != null)
                    {
                        m_PicImage.Dispose();
                    }

                    picBox.SizeMode = PictureBoxSizeMode.StretchImage;

                    m_PicImage = new Bitmap(m_strPicturePath);

                    picBox.Image = (Image)m_PicImage;

                    string strRes = m_PicImage.Height.ToString() + " x " + m_PicImage.Height.ToString();

                    txtboxImageRes.Text = strRes;

                    fileStream.Close();
                }
            }
        }        
    }
}
